﻿//////////////////////////////////////////////
// TestRunException.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkDebug
#include "../../Dll/DllDefines.h"

#include "TestStackLevel.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/BufferView.h>
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkDebug
{
	class DLL_NKDEBUG_EXPORT TestRunException final
	{
		public :

			// Functions
			// Constructors
			TestRunException () noexcept ;
			TestRunException (nkMemory::StringView rejectionReason) noexcept ;
			TestRunException (nkMemory::StringView rejectionReason, nkMemory::BufferCast<TestStackLevel> rejectionStack) noexcept ;

			// Getters
			nkMemory::StringView getRejectionReason () const ;
			nkMemory::BufferView<TestStackLevel> getRejectionStack () const ;

		private :

			// Attributes
			// Results information
			nkMemory::String _rejectionReason ;
			nkMemory::BufferCast<TestStackLevel> _rejectionStack ;
	} ;
}